﻿var userSelector = {
    context: $(".v-userSelector"),
    canModifySettings: $("#ModifyReportingAccess").val() == "True",
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".v-usersTable").a4datatable({            
            advancedFilter: true,
            ajaxAction: a4.getAction("GetUsers", "Reporting", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "FirstName", "Title": resources.FirstName, "Data": "FirstName" },
                { "Name": "LastName", "Title": resources.LastName, "Data": "LastName" }
            ],
            allowRowSelection: true,
            rememberRowSelection: true,
            selectedRows: $(".v-selectedUsers").val()
        });
    },
    bindEvents: function () {
        $(document).on("click", ".v-confirmButton", function () {
            var items = userSelector.datatable.a4datatable("getSelectedItems");            
            var users = _.pluck(items, "Id");
            var groupId = $(".v-groupId").val();
            var portalId = $(".v-portalId").val();
  
            if (groupId > 0) {
                a4.callServerMethod(a4.getAction("UpdateGroupUsers", "Reporting", "Settings"), { groupId: groupId, userIds: users }, function (result) { modalDialog.close(); });
            }
            else if (portalId > 0) {
                a4.callServerMethod(a4.getAction("UpdatePortalUsers", "Reporting", "Settings"), { portalId: portalId, userIds: users }, function (result) { modalDialog.close(); });
            }
            else {
                modalDialog.close();
            }
        });
    }
}

$(document).ready(function () {
    if (userSelector.context.length > 0) {
        userSelector.initializeDataTable();
        userSelector.bindEvents();
    }
});